/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.common.data;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.framework.Framework;
import com.mrcrayfish.framework.api.data.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.data.sync.SyncedDataKey;
import com.mrcrayfish.framework.network.Network;
import com.mrcrayfish.framework.network.message.handshake.S2CSyncedEntityData;
import com.mrcrayfish.framework.network.message.play.S2CUpdateEntityData;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class SyncedEntityData {
    private static final Marker SYNCED_ENTITY_DATA_MARKER = MarkerManager.getMarker((String)"SYNCED_ENTITY_DATA");
    private static final Capability<DataHolder> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DataHolder>(){});
    private static SyncedEntityData instance;
    private final Set<SyncedClassKey<?>> registeredClassKeys = new HashSet();
    private final Object2ObjectMap<ResourceLocation, SyncedClassKey<?>> idToClassKey = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, SyncedClassKey<?>> classNameToClassKey = new Object2ObjectOpenHashMap();
    private final Object2BooleanMap<String> clientClassNameCapabilityCache = new Object2BooleanOpenHashMap();
    private final Object2BooleanMap<String> serverClassNameCapabilityCache = new Object2BooleanOpenHashMap();
    private final Set<SyncedDataKey<?, ?>> registeredDataKeys = new HashSet();
    private final Reference2ObjectMap<SyncedClassKey<?>, HashMap<ResourceLocation, SyncedDataKey<?, ?>>> classToKeys = new Reference2ObjectOpenHashMap();
    private final Reference2IntMap<SyncedDataKey<?, ?>> internalIds = new Reference2IntOpenHashMap();
    private final Int2ReferenceMap<SyncedDataKey<?, ?>> syncedIdToKey = new Int2ReferenceOpenHashMap();
    private final AtomicInteger nextIdTracker = new AtomicInteger();
    private final List<Entity> dirtyEntities = new ArrayList<Entity>();
    private boolean dirty = false;

    private SyncedEntityData() {
    }

    public static SyncedEntityData instance() {
        if (instance == null) {
            instance = new SyncedEntityData();
        }
        return instance;
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(DataHolder.class);
    }

    private <E extends Entity> void registerClassKey(SyncedClassKey<E> classKey) {
        if (!this.registeredClassKeys.contains(classKey)) {
            this.registeredClassKeys.add(classKey);
            this.idToClassKey.put((Object)classKey.id(), classKey);
            this.classNameToClassKey.put((Object)classKey.entityClass().getName(), classKey);
        }
    }

    public synchronized <E extends Entity, T> void registerDataKey(SyncedDataKey<E, T> dataKey) {
        ResourceLocation keyId = dataKey.id();
        SyncedClassKey<E> classKey = dataKey.classKey();
        if (Framework.isGameLoaded()) {
            throw new IllegalStateException(String.format("Tried to register synced data key %s for %s after game initialization", keyId, classKey.id()));
        }
        if (this.registeredDataKeys.contains(dataKey)) {
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is already registered", keyId, classKey.id()));
        }
        this.registerClassKey(dataKey.classKey());
        this.registeredDataKeys.add(dataKey);
        ((HashMap)this.classToKeys.computeIfAbsent(classKey, c -> new HashMap())).put(keyId, dataKey);
        int nextId = this.nextIdTracker.getAndIncrement();
        this.internalIds.put(dataKey, nextId);
        this.syncedIdToKey.put(nextId, dataKey);
        Framework.LOGGER.info(SYNCED_ENTITY_DATA_MARKER, "Registered synced data key {} for {}", (Object)dataKey.id(), (Object)classKey.id());
    }

    public <E extends Entity, T> void set(E entity, SyncedDataKey<?, ?> key, T value) {
        if (!this.registeredDataKeys.contains(key)) {
            String keys = this.registeredDataKeys.stream().map(k -> k.pairKey().toString()).collect(Collectors.joining(",", "[", "]"));
            Framework.LOGGER.info(SYNCED_ENTITY_DATA_MARKER, "Registered keys before throwing exception: {}", (Object)keys);
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is not registered!", key.id(), key.classKey().id()));
        }
        DataHolder holder = this.getDataHolder(entity);
        if (holder != null && holder.set(entity, key, value) && !entity.f_19853_.m_5776_()) {
            this.dirty = true;
            this.dirtyEntities.add(entity);
        }
    }

    public <E extends Entity, T> T get(E entity, SyncedDataKey<E, T> key) {
        if (!this.registeredDataKeys.contains(key)) {
            String keys = this.registeredDataKeys.stream().map(k -> k.pairKey().toString()).collect(Collectors.joining(",", "[", "]"));
            Framework.LOGGER.info(SYNCED_ENTITY_DATA_MARKER, "Registered keys before throwing exception: {}", (Object)keys);
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is not registered!", key.id(), key.classKey().id()));
        }
        DataHolder holder = this.getDataHolder(entity);
        return holder != null ? holder.get(key) : key.defaultValueSupplier().get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <E extends Entity, T> void updateClientEntry(Entity entity, DataEntry<E, T> entry) {
        SyncedEntityData.instance().set(entity, entry.getKey(), entry.getValue());
    }

    public int getInternalId(SyncedDataKey<?, ?> key) {
        return this.internalIds.getInt(key);
    }

    @Nullable
    private SyncedDataKey<?, ?> getKey(int id) {
        return (SyncedDataKey)this.syncedIdToKey.get(id);
    }

    public Set<SyncedDataKey<?, ?>> getKeys() {
        return ImmutableSet.copyOf(this.registeredDataKeys);
    }

    @Nullable
    private DataHolder getDataHolder(Entity entity) {
        return entity.getCapability(CAPABILITY, null).resolve().orElse(null);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (this.hasSyncedDataKey(((Entity)event.getObject()).getClass())) {
            Provider provider = new Provider();
            event.addCapability(new ResourceLocation("framework", "synced_entity_data"), (ICapabilityProvider)provider);
            if (!(event.getObject() instanceof ServerPlayer)) {
                event.addListener(provider::invalidate);
            }
        }
    }

    private boolean hasSyncedDataKey(Class<? extends Entity> entityClass) {
        return this.getClassNameCapabilityCache().computeIfAbsent((Object)entityClass.getName(), c -> {
            Class targetClass = entityClass;
            while (!targetClass.isAssignableFrom(Entity.class)) {
                if (this.classNameToClassKey.containsKey((Object)targetClass.getName())) {
                    return true;
                }
                targetClass = targetClass.getSuperclass();
            }
            return false;
        });
    }

    private Object2BooleanMap<String> getClassNameCapabilityCache() {
        return EffectiveSide.get().isClient() ? this.clientClassNameCapabilityCache : this.serverClassNameCapabilityCache;
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity;
        DataHolder holder;
        if (!event.getPlayer().f_19853_.m_5776_() && (holder = this.getDataHolder(entity = event.getTarget())) != null) {
            List<DataEntry<?, ?>> entries = holder.gatherAll();
            entries.removeIf(entry -> !entry.getKey().syncMode().isTracking());
            if (!entries.isEmpty()) {
                Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new S2CUpdateEntityData(entity.m_142049_(), entries));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            List<DataEntry<?, ?>> entries;
            DataHolder holder;
            Player player = (Player)entity;
            if (!event.getWorld().m_5776_() && (holder = this.getDataHolder((Entity)player)) != null && !(entries = holder.gatherAll()).isEmpty()) {
                Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new S2CUpdateEntityData(player.m_142049_(), entries));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        original.reviveCaps();
        DataHolder oldHolder = this.getDataHolder((Entity)original);
        if (oldHolder == null) {
            return;
        }
        original.invalidateCaps();
        Player player = event.getPlayer();
        DataHolder newHolder = this.getDataHolder((Entity)player);
        if (newHolder == null) {
            return;
        }
        HashMap dataMap = new HashMap(oldHolder.dataMap);
        if (event.isWasDeath()) {
            dataMap.entrySet().removeIf(entry -> !((SyncedDataKey)entry.getKey()).persistent());
        }
        newHolder.dataMap = dataMap;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.dirty) {
            return;
        }
        if (this.dirtyEntities.isEmpty()) {
            this.dirty = false;
            return;
        }
        for (Entity entity : this.dirtyEntities) {
            List<DataEntry<?, ?>> trackingEntries;
            List<DataEntry<?, ?>> entries;
            DataHolder holder = this.getDataHolder(entity);
            if (holder == null || !holder.isDirty() || (entries = holder.gatherDirty()).isEmpty()) continue;
            List<DataEntry<?, ?>> selfEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isSelf()).collect(Collectors.toList());
            if (!selfEntries.isEmpty() && entity instanceof ServerPlayer) {
                Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), (Object)new S2CUpdateEntityData(entity.m_142049_(), selfEntries));
            }
            if (!(trackingEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isTracking()).collect(Collectors.toList())).isEmpty()) {
                Network.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new S2CUpdateEntityData(entity.m_142049_(), trackingEntries));
            }
            holder.clean();
        }
        this.dirtyEntities.clear();
        this.dirty = false;
    }

    public boolean updateMappings(S2CSyncedEntityData message) {
        this.syncedIdToKey.clear();
        ArrayList missingKeys = new ArrayList();
        message.getKeyMap().forEach((classId, list) -> {
            SyncedClassKey classKey = (SyncedClassKey)this.idToClassKey.get(classId);
            if (classKey == null || !this.classToKeys.containsKey((Object)classKey)) {
                list.forEach(pair -> missingKeys.add(Pair.of((Object)classId, (Object)((ResourceLocation)pair.getLeft()))));
                return;
            }
            Map keys = (Map)this.classToKeys.get((Object)classKey);
            list.forEach(pair -> {
                SyncedDataKey syncedDataKey = (SyncedDataKey)keys.get(pair.getLeft());
                if (syncedDataKey == null) {
                    missingKeys.add(Pair.of((Object)classId, (Object)((ResourceLocation)pair.getLeft())));
                    return;
                }
                this.syncedIdToKey.put(((Integer)pair.getRight()).intValue(), (Object)syncedDataKey);
            });
        });
        if (!missingKeys.isEmpty()) {
            String keys = missingKeys.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
            Framework.LOGGER.info(SYNCED_ENTITY_DATA_MARKER, "Received unknown synced keys: {}", (Object)keys);
        }
        return missingKeys.isEmpty();
    }

    private static class DataHolder {
        private Map<SyncedDataKey<?, ?>, DataEntry<?, ?>> dataMap = new HashMap();
        private boolean dirty = false;

        private DataHolder() {
        }

        private <E extends Entity, T> boolean set(E entity, SyncedDataKey<?, ?> key, T value) {
            DataEntry entry = this.dataMap.computeIfAbsent(key, DataEntry::new);
            if (!entry.getValue().equals(value)) {
                boolean dirty = !entity.f_19853_.m_5776_() && entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE;
                entry.setValue(value, dirty);
                this.dirty = dirty;
                return true;
            }
            return false;
        }

        @Nullable
        private <E extends Entity, T> T get(SyncedDataKey<E, T> key) {
            return this.dataMap.computeIfAbsent(key, DataEntry::new).getValue();
        }

        private boolean isDirty() {
            return this.dirty;
        }

        private void clean() {
            this.dirty = false;
            this.dataMap.forEach((key, entry) -> entry.clean());
        }

        private List<DataEntry<?, ?>> gatherDirty() {
            return this.dataMap.values().stream().filter(DataEntry::isDirty).filter(entry -> entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE).collect(Collectors.toList());
        }

        private List<DataEntry<?, ?>> gatherAll() {
            return this.dataMap.values().stream().filter(entry -> entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE).collect(Collectors.toList());
        }
    }

    public static class DataEntry<E extends Entity, T> {
        private final SyncedDataKey<E, T> key;
        private T value;
        private boolean dirty;

        private DataEntry(SyncedDataKey<E, T> key) {
            this.key = key;
            this.value = key.defaultValueSupplier().get();
        }

        private SyncedDataKey<E, T> getKey() {
            return this.key;
        }

        private T getValue() {
            return this.value;
        }

        private void setValue(T value, boolean dirty) {
            this.value = value;
            this.dirty = dirty;
        }

        private boolean isDirty() {
            return this.dirty;
        }

        private void clean() {
            this.dirty = false;
        }

        public void write(FriendlyByteBuf buffer) {
            int id = SyncedEntityData.instance().getInternalId(this.key);
            buffer.m_130130_(id);
            this.key.serializer().write(buffer, this.value);
        }

        public static DataEntry<?, ?> read(FriendlyByteBuf buffer) {
            SyncedDataKey<?, ?> key = SyncedEntityData.instance().getKey(buffer.m_130242_());
            Validate.notNull(key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
            DataEntry entry = new DataEntry(key);
            entry.readValue(buffer);
            return entry;
        }

        private void readValue(FriendlyByteBuf buffer) {
            this.value = this.getKey().serializer().read(buffer);
        }

        private Tag writeValue() {
            return this.key.serializer().write(this.value);
        }

        private void readValue(Tag nbt) {
            this.value = this.key.serializer().read(nbt);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<ListTag> {
        final DataHolder holder = new DataHolder();
        final LazyOptional<DataHolder> optional = LazyOptional.of(() -> this.holder);

        public void invalidate() {
            this.optional.invalidate();
        }

        public ListTag serializeNBT() {
            ListTag list = new ListTag();
            this.holder.dataMap.forEach((key, entry) -> {
                if (key.save()) {
                    CompoundTag keyTag = new CompoundTag();
                    keyTag.m_128359_("ClassKey", key.classKey().id().toString());
                    keyTag.m_128359_("DataKey", key.id().toString());
                    keyTag.m_128365_("Value", entry.writeValue());
                    list.add((Object)keyTag);
                }
            });
            return list;
        }

        public void deserializeNBT(ListTag listTag) {
            this.holder.dataMap.clear();
            listTag.forEach(entryTag -> {
                CompoundTag keyTag = (CompoundTag)entryTag;
                ResourceLocation classKey = ResourceLocation.m_135820_((String)keyTag.m_128461_("ClassKey"));
                ResourceLocation dataKey = ResourceLocation.m_135820_((String)keyTag.m_128461_("DataKey"));
                Tag value = keyTag.m_128423_("Value");
                SyncedClassKey syncedClassKey = (SyncedClassKey)SyncedEntityData.instance().idToClassKey.get((Object)classKey);
                if (syncedClassKey == null) {
                    return;
                }
                Map keys = (Map)SyncedEntityData.instance().classToKeys.get((Object)syncedClassKey);
                if (keys == null) {
                    return;
                }
                SyncedDataKey syncedDataKey = (SyncedDataKey)keys.get(dataKey);
                if (syncedDataKey == null || !syncedDataKey.save()) {
                    return;
                }
                DataEntry entry = new DataEntry(syncedDataKey);
                entry.readValue(value);
                this.holder.dataMap.put(syncedDataKey, entry);
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.optional);
        }
    }
}

